//  Copyright (c) 2022 Ham Radio Solutions
//
//  CW Hotline case

$fa = 1;
$fs = 0.4;

boxDepth=100;
boxWidth=60;
boxHeight=23;
boxWallThickness=2;
boxRoundness=1.5;

boardThickness=1.6;

USBAccessDiameter=5;

jackOffset=34;
jackDiameter=7;

speedSwitchDiameter=5;
LEDDiameter=3.5;

SpeakerHoleDiameter=1.75;
SpeakerDiameter=10;

bossHeight=6;
bossOuterDiameter=3.5;
bossInnerDiameter=1.25;

difference() {

    //  The major dimensions of the box
    translate([boxRoundness, boxRoundness, boxRoundness])
    minkowski() {
        cube([boxWidth - boxRoundness*2, boxDepth - boxRoundness*2, boxHeight - boxRoundness*2]);
        sphere(boxRoundness);
    }

    //  Then we hollow it out
    translate([boxWallThickness,boxWallThickness,boxWallThickness])
        cube([(boxWidth - (boxWallThickness*2)), (boxDepth - (boxWallThickness * 2)), (boxHeight + boxRoundness + 0.1)]);

    //  Then chop off the top
    //translate([boxWidth-boxWallThickness,boxDepth - boxWallThickness,boxHeight-boxWallThickness])
    translate([0, 0, boxHeight-boxWallThickness])
        cube([boxWidth, boxDepth, boxHeight]);

    //  Add the hole for the USB connector
    for (hole = [-5:5]) {
        translate([(boxWidth / 2)+hole, boxWallThickness, (bossHeight + (USBAccessDiameter / 2) + boxWallThickness + boardThickness)])
            rotate([90,90,0])
            cylinder(boxWallThickness+0.2,USBAccessDiameter,USBAccessDiameter);
    }
    
    //  Add the holes for the 3 TRS jacks
    for (hole = [-1:1]) {
    //  Add the holes for the 3 TRS jacks
    translate([boxWidth - boxWallThickness,boxDepth / 2 - (jackOffset * hole),(bossHeight + (jackDiameter / 2) + boxWallThickness + boardThickness)])
        rotate([0,90,0])
        cylinder(boxWallThickness * 2,jackDiameter/2,jackDiameter/2);

    }
    

    //  Add the hole for the speed switch
    translate([10 + boxWallThickness, boxDepth - 10 - boxWallThickness, 0])
        rotate([0,0,0])
        cylinder(boxWallThickness*2,speedSwitchDiameter/2,speedSwitchDiameter/2);
    
    //  Add the hole for the key LED
    translate([10 + boxWallThickness, boxDepth - 23 - boxWallThickness, 0])
        rotate([0,0,0])
        cylinder(boxWallThickness*2,LEDDiameter/2,LEDDiameter/2);
    
    //  Add the hole for the link LED
    translate([10 + boxWallThickness, boxDepth - 31 - boxWallThickness, 0])
        rotate([0,0,0])
        cylinder(boxWallThickness*2,LEDDiameter/2,LEDDiameter/2);
    
    //  Add the holes for the speaker
    translate([10 + boxWallThickness, boxDepth / 2, 0])
        rotate([0,0,0])
        cylinder(boxWallThickness*2,SpeakerHoleDiameter/2,SpeakerHoleDiameter/2);
        
    for (hole = [0:5]) {
        translate([10 + boxWallThickness, boxDepth / 2, 0])
        translate([sin((hole*60))*SpeakerDiameter/2, cos((hole*60))*SpeakerDiameter/2,0])
        cylinder(boxWallThickness*2,SpeakerHoleDiameter/2,SpeakerHoleDiameter/2);
    }
    
}

bossFactor=3;
//  Add the 4 bosses
difference() {
translate([boxWallThickness*bossFactor,boxWallThickness*bossFactor,boxWallThickness])
        
        cylinder(bossHeight,bossOuterDiameter,bossOuterDiameter);
translate([boxWallThickness*bossFactor,boxWallThickness*bossFactor,boxWallThickness])
        cylinder((bossHeight + 0.1),bossInnerDiameter,bossInnerDiameter);
}

difference() {
translate([(boxWidth-(boxWallThickness * bossFactor)),boxWallThickness*bossFactor,boxWallThickness])
        cylinder(bossHeight,bossOuterDiameter,bossOuterDiameter);
translate([(boxWidth-(boxWallThickness * bossFactor)),boxWallThickness*bossFactor,boxWallThickness])
        cylinder((bossHeight + 0.1),bossInnerDiameter,bossInnerDiameter);
}


difference() {
translate([boxWallThickness*bossFactor,boxDepth-boxWallThickness*bossFactor,boxWallThickness])
        
        cylinder(bossHeight,bossOuterDiameter,bossOuterDiameter);
translate([boxWallThickness*bossFactor,boxDepth-boxWallThickness*bossFactor,boxWallThickness])
        cylinder((bossHeight + 0.1),bossInnerDiameter,bossInnerDiameter);
}

difference() {
translate([(boxWidth-(boxWallThickness * bossFactor)),boxDepth-boxWallThickness*bossFactor,boxWallThickness])
        
        cylinder(bossHeight,bossOuterDiameter,bossOuterDiameter);
translate([(boxWidth-(boxWallThickness * bossFactor)),boxDepth-boxWallThickness*bossFactor,boxWallThickness])
        cylinder((bossHeight + 0.1),bossInnerDiameter,bossInnerDiameter);
}
